# Next Line tells OSX this is a bash script
#!/bin/bash

# Next Line sets the path for the executable to current folder
cd "$(dirname "$0")"

# Next Section of lines starts QEMU and passes the stated parameters
# L defines the location of bios files to be used
# M defines the mac model used
# m defines the amount of memory in MB
# boot c defines to boot from a drive entry marked as disk
# drive file defines a hard disk image or CD ISO image
# netdev passes internet to the emulated PPC

./qemu-system-ppc \
-L pc-bios \
-M mac99,via=pmu \
-m 768 \
-boot c \
-drive file=MacOS922_Lives.img,format=raw,media=disk \
-netdev user,id=network01 -device sungem,netdev=network01 \
-device VGA,edid=on \
